struct LuaExample
{
	char* name;
	char* lua;
};
const LuaExample luaExamples [] =
{
	{
	"Lua basics / cheatsheet",
	
	"-- Lua introduction / cheatsheet\n"
	"\n"
	"-- This is single-line comment\n"
	"--[[\n"
	"   This is multi-line\n"
	"   comment.\n"
	"--]]\n"
	"\n"
	"-- Undefined variables return nil (not generating error)\n"
	"str = 'text'    -- Variable declaration/definition; global by default\n"
	"str = nil       -- Undefines \"str\" variable; Lua uses garbage collector\n"
	"\n"
	"print(\"\\n\\n##### Starting script #####\\n\\n\")\n"
	"\n"
	"-- Conditionals\n"
	"num = 5\n"
	"if num > 6 then\n"
	"    print('num is larger than 6\\n')   -- print output goes to tSIP log window\n"
	"elseif num == 23 then               -- equality operator: ==\n"
	"    print('num equals 23\\n')       -- also -> tSIP log window\n"
	"else\n"
	"\t-- local variable\n"
	"    local messageText = string.format(\"Num value = %d\\n\", num);\n"
	"    print(messageText)\n"
	"end\n"
	"\n"
	"if 0 then\n"
	"    print(\"Only nil and false values are interpreted as false condition\\n\")\n"
	"end\n"
	"\n"
	"-- Multi-line comments can be used as C's \"#if 0\"\n"
	"-- Remove one '-' from line below to disable this block\n"
	"---[[\n"
	"\tprint(\"Block of code - enabled\\n\")\n"
	"--]]\n"
	"\n"
	"-- Loops\n"
	"\n"
	"while num < 10 do\n"
	"\tprint(\"Incrementing num\\n\")\n"
	"\tnum = num + 1  -- No ++/-- or += type (shorthand) operators.\n"
	"end\n"
	"\n"
	"local sum = 0\n"
	"for i = 1, num do  -- Range includes both ends.\n"
	"\tsum = sum + i\n"
	"end\n"
	"print(string.format(\"Sum of numbers from 1 to %d: %d\\n\", num, sum))\n"
	"\n"
	"for j = 3, 1, -1 do\n"
	"\t-- \"..\" = concatenation operator\n"
	"\tprint(\"Counting down: \" .. j .. \"\\n\")\n"
	"end\n"
	"\n"
	"repeat\n"
	"\tnum = num - 1\n"
	"until num == 0\n"
	"\n"
	"-- Tables are indexed by default by integers (starting from 1)\n"
	"local myTable = {'first value', 'second value', 3, 4.76}\n"
	"print 'myTable values: '\n"
	"for i = 1, #myTable do  -- #myTable = table size\n"
	"\tif i ~= 1 then\n"
	"\t\tprint ', '\n"
	"\tend\n"
	"\tprint (myTable[i])\n"
	"end\n"
	"print '\\n'\n"
	"\n"
	"\n"
	"print(\"\\n\\n##### End of script #####\\n\\n\")"
	}
	,
	{
	"Beep",

	"-- ShowMessage(\"Press \\\"Break\\\" to stop\")\n"
	"pattern =\n"
	"{\n"
	"-- frequency, time\n"
	"{392 \t,350}, \n"
	"{392 \t,350}, \n"
	"{392 \t,350}, \n"
	"{311 \t,250}, \n"
	"{466 \t,250},\n"
	"{392 \t,350}, \n"
	"{311 \t,250}, \n"
	"{466 \t,250},\n"
	"{392 \t,700}, \n"
	"{587 ,350}, \n"
	"{587 ,350}, \n"
	"{587 ,350}, \n"
	"{622 ,250}, \n"
	"{466 \t,250},\n"
	"{369 ,350}, \n"
	"{311 \t,250}, \n"
	"{466 \t,250},\n"
	"{392 \t,700}, \n"
	"{784 \t,350}, \n"
	"{392 \t,250}, \n"
	"{392 \t,250},\n"
	"{784 \t,350}, \n"
	"{739 ,250}, \n"
	"{698 ,250},\n"
	"{659 ,250},\n"
	"{622 ,250},\n"
	"{659 ,500}, \n"
	"{0, 300},\n"
	"{415 \t,250},\n"
	"{0,100},\n"
	"{554 ,350}, \n"
	"{523 ,250}, \n"
	"{493 ,250},\n"
	"{466 ,250},\n"
	"{440 \t,250},\n"
	"{466 ,500}, \n"
	"{0,300},\n"
	"{311 ,250},\n"
	"{0,100},\n"
	"{369 ,350}, \n"
	"{311 ,250}, \n"
	"{392 \t,250},\n"
	"{466 ,350}, \n"
	"{392 \t,250}, \n"
	"{466 ,250},\n"
	"{587 ,700}, \n"
	"{784 \t,350}, \n"
	"{392 \t,250}, \n"
	"{392 \t,250}, \n"
	"{784 \t,350}, \n"
	"{739 ,250}, \n"
	"{698 ,250},\n"
	"{659 ,250},\n"
	"{622 ,250},\n"
	"{659 ,500}, \n"
	"{0,300},\n"
	"{415 \t,250},\n"
	"{0,100},\n"
	"{554 ,350}, \n"
	"{523 ,250}, \n"
	"{493 ,250},\n"
	"{466 ,250},\n"
	"{440 \t,250},\n"
	"{466 ,500},\n"
	"{0,300}, \n"
	"{311 ,250},\n"
	"{0,200}, \n"
	"{392 \t,250}, \n"
	"{311 ,250}, \n"
	"{466 ,250},\n"
	"{392 ,300}, \n"
	"{0,500},\n"
	"{311 ,250}, \n"
	"\n"
	"}\n"
	"\n"
	"local winapi = require(\"tsip_winapi\")\n"
	"\n"
	"for i = 1, #pattern do\n"
	"\twinapi.Beep(pattern[i][1], pattern[i][2])\n"
	"\tret = CheckBreak()\n"
	"\tSleep(100)\t-- process Win messages also\n"
	"\t-- break on user request\\n\"\n"
	"\tif ret ~= 0 then\n"
	"\t\tprint ('User break\\n')\n"
	"\t\tbreak\n"
	"\tend\n"
	"end\n"
	""
	},

	{
	"Calling: loop",

	"-- calling specified number in the loop\n"
	"print(string.format(\"Running %s on %s\\n\", _VERSION, os.date()))\n"
	"-- clear digits already in Dial edit to be sure\n"
	"for i = 1, 10 do\n"
	"\tCall(\"2007\")\n"
	"\tSleep(2000)\n"
	"\tHangup()\n"
	"\tSleep(100)\n"
	"\tret = CheckBreak()\n"
	"\t-- break on user request\n"
	"\tif ret ~= 0 then\n"
	"\t\tprint ('User break\\n')\n"
	"\t\tbreak\n"
	"\tend\t\n"
	"end\n"
	"print(\"Done\\n\");"

	},

	{
	"Call + DTMFs",
	
	"-- calling and sending DTMFs\n"
	"print(string.format(\"Running %s on %s\\n\", _VERSION, os.date()))\n"
	"Call(\"2000\")\n"
	"Sleep(5000)\n"
	"-- hoping that 2nd party would answer the call in meantime\n"
	"SendDtmf(\"012345678*#\")\n"
	"-- pause to let digits get out of the queues safely\n"
	"Sleep(3000)\n"
	"Hangup()\n"
	"print(\"Done\\n\");"
	},

	{
	"Call to specified number (conference room) and enter code",

	"-- user config\n"
	"number = \"123456789\"\n"
	"dtmf = \"1234\"\n"
	"-- end of user config\n"
	" \n"
	"Call(number)\n"
	"for i=1, 20, 1\n"
	"do\n"
	"\tif (i == 20) then\n"
	"\t\tprint(\"Timed out waiting for confirmed state\\n\")\n"
	"\t\tbreak;\n"
	"\tend\n"
	" \n"
	"\tSleep(300)\n"
	"\tcall_state = GetCallState()\n"
	"\tif call_state == 6 then\n"
	"\t\t-- CALL_STATE_ESTABLISHED\n"
	"\t\tSleep(2000)\n"
	"\t\tSendDtmf(\"1234\")\n"
	"\t\tbreak\n"
	"\telseif call_state == 0 then\n"
	"\t\t-- CALL_STATE_CLOSED\n"
	"\t\tprint(\"End of call\\n\")\n"
	"\t\tbreak;\n"
	"\tend\n"
	"end\n"
	"print(\"End of script\\n\")  "
	}
	,
	{
	"Count number of times script was executed",
	
	"-- This script counts number of times it was executed\n"
	"local count, var_isset = GetVariable(\"runcount\")\n"
	"if (var_isset == 0) then\n"
	"\tcount = 0\n"
	"else\n"
	"\tcount = tonumber(count)\n"
	"end\n"
	"\n"
	"count = count + 1\n"
	"SetVariable(\"runcount\", count)\n"
	"print(string.format(\"Script executed %d time(s)\\n\", count))  "
	}
	,
	{
	"PlaySound",

	"-- Playing sound asynchronously\n"
	"-- note: more powerful (sound device selection) option is using sox tool + ShellExecute\n"
	"-- (http://tomeko.net/software/SIPclient/howto/sox.php, http://tomeko.net/software/SIPclient/howto/local_dtmfs.php)\n"
	"\n"
	"local winapi = require(\"tsip_winapi\")\n"
	"\n"
	"-- let's use path relative to exe location\n"
	"local filename = GetExeName()\n"
	"local index = string.find(filename:reverse(), \"\\\\\")\n"
	"local dir = string.sub(filename, 1, -index)\n"
	"local audio_file = dir .. \"pluck.wav\"\n"
	"\n"
	"-- PlaySound is identical to WinAPI function with same name\n"
	"local SND_FILENAME = tonumber(0x00020000)\n"
	"local SND_ASYNC = tonumber(0x0001)\n"
	"winapi.PlaySound(audio_file, 0, SND_FILENAME | SND_ASYNC)"
	}

};
