//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "FormCH341I2CCH1115.h"
#include "CH1115.h"
#include "ssd1306/textRenderer/TextRenderer.h"
#include "ssd1306/shapeRenderer/ShapeRenderer.h"
#include "CH341A.h"
#include "TabManager.h"
#include "common/BtnController.h"
#include "Log.h"
#include <assert.h>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfrmCH341I2CCH1115 *frmCH341I2CCH1115;
//---------------------------------------------------------------------------


namespace
{

// https://goldenmorninglcd.com/oled-display/0.5-inch-oled-88x48-ch1115-gme8848-01/
// 2 lines inside rectangle:
//   0.50"
// 88x48DOTS
uint8_t image1[]={
0xFF,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xFC,0x02,0x01,0x01,0x01,0x02,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,
0x11,0x11,0x11,0x21,0xC1,0x00,0x00,0xFC,0x02,0x01,0x01,0x01,0x02,0xFC,0x00,0x00,
0x00,0x0F,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x04,0x04,0x04,0x02,0x01,
0x00,0x00,0x06,0x06,0x00,0x00,0x00,0x02,0x04,0x04,0x04,0x02,0x01,0x00,0x00,0x01,
0x02,0x04,0x04,0x04,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,0x8E,0x53,0x31,0x21,
0x31,0x53,0x8E,0x00,0x00,0x8E,0x53,0x31,0x21,0x31,0x53,0x8E,0x00,0x01,0x03,0x06,
0xDC,0x70,0x70,0xDC,0x06,0x03,0x01,0x80,0xE0,0xB0,0x88,0x84,0x83,0xFF,0x80,0x00,
0x00,0x8E,0x53,0x31,0x21,0x31,0x53,0x8E,0x00,0x00,0x00,0xFE,0x02,0x02,0x02,0x02,
0x04,0x0C,0xF0,0x00,0x00,0xF0,0x0C,0x06,0x02,0x02,0x02,0x06,0x0C,0xF8,0x00,0x02,
0x02,0x02,0xFE,0x02,0x02,0x02,0x00,0x1C,0x26,0x62,0x42,0xC2,0x84,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x03,0x06,0x04,0x04,0x04,0x06,0x03,0x00,0x00,0x03,0x06,0x04,
0x04,0x04,0x06,0x03,0x00,0x04,0x06,0x03,0x01,0x00,0x00,0x01,0x03,0x06,0x04,0x00,
0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x03,0x06,0x04,0x04,0x04,0x06,0x03,
0x00,0x00,0x00,0x07,0x04,0x04,0x04,0x04,0x02,0x03,0x00,0x00,0x00,0x01,0x03,0x06,
0x04,0x04,0x04,0x06,0x03,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x02,
0x04,0x04,0x04,0x04,0x03,0x00,0x00,0xFF,0xFF,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xFF,
};

// https://goldenmorninglcd.com/oled-display/0.5-inch-oled-88x48-ch1115-gme8848-01/
// 3 text lines:
// 0123456789
// abcdABCDEF
// ...
uint8_t image2[]={
0xFF,0x01,0x01,0x01,0x01,0x01,0x01,0x81,0x41,0x41,0xC1,0x01,0x01,0x01,0x01,0x81,
0xC1,0xC1,0x01,0x01,0x01,0x01,0x01,0x81,0x41,0x41,0x41,0x81,0x01,0x01,0x81,0x41,
0x41,0x41,0x81,0x01,0x01,0x01,0x01,0x01,0x01,0xC1,0xC1,0x01,0x01,0x01,0xC1,0x41,
0x41,0x41,0x41,0x41,0x01,0x01,0x01,0x81,0x41,0x41,0x41,0x01,0x01,0x01,0x41,0x41,
0x41,0x41,0x41,0xC1,0x01,0x01,0x81,0x41,0x41,0x41,0x41,0x81,0x01,0x01,0x81,0xC1,
0x41,0x41,0xC1,0x01,0x01,0x01,0x01,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x3F,0xC0,
0x80,0x80,0x40,0x3F,0x00,0x00,0x00,0x80,0x80,0xFF,0x80,0x80,0x00,0x00,0x80,0xC0,
0xA0,0x90,0x8C,0x87,0x00,0x00,0x40,0x84,0x84,0xCC,0x7B,0x00,0x00,0x10,0x1C,0x12,
0x11,0x10,0xFF,0x10,0x00,0x00,0x47,0x84,0x84,0x84,0x4C,0x78,0x00,0x00,0x3F,0xC8,
0x84,0x84,0xCC,0x78,0x00,0x00,0x00,0x80,0x70,0x0C,0x03,0x00,0x00,0x00,0x73,0xCC,
0x84,0x8C,0x8A,0x73,0x00,0x00,0x07,0x8C,0x88,0x88,0x4C,0x3F,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x40,0x40,0x80,0x00,0x00,0xF8,0x80,0x40,
0x40,0xC0,0x80,0x00,0x00,0x00,0x80,0x40,0x40,0x40,0x00,0x00,0x80,0xC0,0x40,0x40,
0xC0,0xF8,0x00,0x00,0x00,0x80,0x70,0x08,0x70,0x80,0x00,0x00,0x00,0xF8,0x88,0x88,
0x88,0x70,0x00,0x00,0x00,0xC0,0x30,0x10,0x08,0x08,0x08,0x10,0x00,0x00,0xF8,0x08,
0x08,0x08,0x08,0x10,0x30,0xC0,0x00,0x00,0xF8,0x88,0x88,0x88,0x88,0x00,0x00,0xF8,
0x88,0x88,0x88,0x88,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x0C,0x12,
0x12,0x8A,0x1F,0x00,0x00,0x1F,0x08,0x10,0x10,0x18,0x0F,0x00,0x00,0x0F,0x18,0x10,
0x10,0x10,0x00,0x00,0x0F,0x18,0x10,0x10,0x08,0x1F,0x00,0x10,0x0E,0x03,0x02,0x02,
0x02,0x03,0x0E,0x10,0x00,0x1F,0x10,0x10,0x10,0x0F,0x00,0x00,0x00,0x07,0x0C,0x18,
0x10,0x10,0x10,0x88,0x00,0x00,0x1F,0x10,0x10,0x10,0x10,0x08,0x0C,0x03,0x80,0x00,
0x1F,0x90,0x10,0x10,0x10,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x0E,0x1B,0x11,0xFF,0x21,0xC2,0x00,0x24,0xA4,0x7C,
0x27,0xA4,0x7C,0x27,0x24,0x00,0xC0,0x2E,0x19,0x11,0x29,0x66,0xC0,0x60,0x1C,0x00,
0x00,0xF8,0x06,0x01,0x01,0x06,0xF8,0x00,0x00,0xF8,0x04,0x02,0xF1,0x0D,0x05,0x85,
0xFD,0x02,0x86,0xF8,0x00,0x00,0xFC,0x44,0x44,0x44,0x44,0xFF,0x44,0x44,0x44,0x44,
0xFC,0x00,0x00,0x88,0x84,0xBF,0x90,0x90,0x88,0xBF,0xA4,0xA2,0xA2,0xA1,0x98,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x80,0x80,0x80,0x80,0x80,0x81,0x82,
0x82,0x87,0x82,0x81,0x80,0x80,0x81,0x80,0x80,0x81,0x80,0x80,0x80,0x80,0x81,0x83,
0x82,0x82,0x82,0x81,0x81,0x81,0x82,0x82,0x80,0x81,0x86,0x88,0x88,0x86,0x81,0x80,
0x80,0x80,0x83,0x82,0x84,0x85,0x85,0x84,0x83,0x81,0x81,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x87,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x87,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xFF,
};


}	// namespace

__fastcall TfrmCH341I2CCH1115::TfrmCH341I2CCH1115(TComponent* Owner)
	: TForm(Owner)
{
	TabManager::Instance().Register(this);
}
//---------------------------------------------------------------------------

__fastcall TfrmCH341I2CCH1115::~TfrmCH341I2CCH1115(void)
{
	if (display)
		delete display;
}

uint8_t TfrmCH341I2CCH1115::GetAddress(void)
{
	switch (cbI2CAddress->ItemIndex)
	{
	case 0:
		return 0x3C;
	case 1:
		return 0x3D;
	default:
		assert(!"Unhandled address!");
		return 0;
	}
}




void __fastcall TfrmCH341I2CCH1115::btnInitClick(TObject *Sender)
{
	if (!ch341a.IsOpened())
	{
		lblStatus->Caption = "CH341 is not opened!";
		return;
	}

	uint8_t address = GetAddress();

	int status = ch341a.I2CCheckDev(address);
	if (status != 0)
	{
		lblStatus->Caption = "No ACK after sending address!";
		return;
	}

	(void)font_5x8;
	(void)font_8x8;
	(void)font_12x16;
	(void)font_16x32;

	if (display)
	{
		delete display;
		display = NULL;
	}

	display = new CH1115(ch341a, address);

    // Here we rotate the display by 180 degrees, so that it's not upside down from my perspective
    // If your screen is upside down try setting it to 1 or 0
	display->setOrientation(1);

	display->clear();
	display->setContrast(static_cast<unsigned char>(trbarContrast->Position));	

	{
		unsigned k=0;
		const uint8_t *image;
		if (cbImage->ItemIndex == 0)
			image = image1;
		else
			image = image2;
		for(uint8_t j=0;j<CH1115::HEIGHT/8;j++)
		{
			display->setPage(j);
			display->setColumn(0);
			display->data(image+k, CH1115::WIDTH);
			k += CH1115::WIDTH;
		}
	}

	lblStatus->Caption = "";
}
//---------------------------------------------------------------------------

void __fastcall TfrmCH341I2CCH1115::btnInvertDisplayClick(TObject *Sender)
{
	BtnController btnCtrl(btnInvertDisplay);

	if (!ch341a.IsOpened())
	{
		lblStatus->Caption = "CH341 is not opened!";
		return;
	}

	if (display == NULL)
	{
		lblStatus->Caption = "Display is not initialized!";
		return;
	}

	display->invertDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TfrmCH341I2CCH1115::btnTurnOnClick(TObject *Sender)
{
	BtnController btnCtrl(dynamic_cast<TButton*>(Sender));

	lblStatus->Caption = "";
	if (!ch341a.IsOpened())
	{
		lblStatus->Caption = "CH341 is not opened!";
		return;
	}

	if (display == NULL)
	{
		lblStatus->Caption = "Display is not initialized!";
		return;
	}

	display->turnOn();
}
//---------------------------------------------------------------------------

void __fastcall TfrmCH341I2CCH1115::btnTurnOffClick(TObject *Sender)
{
	BtnController btnCtrl(dynamic_cast<TButton*>(Sender));

	lblStatus->Caption = "";
	if (!ch341a.IsOpened())
	{
		lblStatus->Caption = "CH341 is not opened!";
		return;
	}

	if (display == NULL)
	{
		lblStatus->Caption = "Display is not initialized!";
		return;
	}

	display->turnOff();	
}
//---------------------------------------------------------------------------

void __fastcall TfrmCH341I2CCH1115::trbarContrastChange(TObject *Sender)
{
	if (!ch341a.IsOpened())
	{
		lblStatus->Caption = "CH341 is not opened!";
		return;
	}

	if (display == NULL)
	{
		lblStatus->Caption = "Display is not initialized!";
		return;
	}
	display->setContrast(static_cast<unsigned char>(trbarContrast->Position));	
}
//---------------------------------------------------------------------------

void __fastcall TfrmCH341I2CCH1115::btnClearDisplayClick(TObject *Sender)
{
	BtnController btnCtrl(dynamic_cast<TButton*>(Sender));

	lblStatus->Caption = "";
	if (!ch341a.IsOpened())
	{
		lblStatus->Caption = "CH341 is not opened!";
		return;
	}

	if (display == NULL)
	{
		lblStatus->Caption = "Display is not initialized!";
		return;
	}

	display->clear();
}
//---------------------------------------------------------------------------


